///////////////////////////////////////////////////////////////////////////////////////////////
//Ship-to-ship combat code.
//Created: 12/17/04
//Last Update: 12/18/04
///////////////////////////////////////////////////////////////////////////////////////////////

const PLAYER_TURN = 0
const ENEMY_TURN = 1

const ZOOM_POINT = 0;
const TARGET_POINT = 1;
const ATTACK_POINT = 2;

///////////////////////////////////////////////////////////////////////////////////////////////

var gShipBattle_Data

///////////////////////////////////////////////////////////////////////////////////////////////

function ShipBattle_Update()
{
	gSuspendMovement = true
	
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	gShipBattle_Data.move_timer--;
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	if (gShipBattle_Data.turn == PLAYER_TURN) 
		{
			var Ship = gShipBattle_Data.Player_Ship
			var OShip = gShipBattle_Data.Enemy_Ship
		}
							
	else
		{
			var Ship = gShipBattle_Data.Enemy_Ship	
			var OShip = gShipBattle_Data.Player_Ship
		}		
	
	if (gShipBattle_Data.move_timer <= 0)
		{	
			gShipBattle_Data.bg_pos+=3
			if (gShipBattle_Data.bg_pos >= 320) gShipBattle_Data.bg_pos = 0
		
			//Update ship movements
			if ( gShipBattle_Data.point != ATTACK_POINT )
				{
					if (Ship.x < Ship.nx) Ship.x++;
					if (Ship.x > Ship.nx) Ship.x--;
					
					if (Ship.y < Ship.ny) Ship.y++;
					if (Ship.y > Ship.ny) Ship.y--;		
					
					if (OShip.x < OShip.nx) OShip.x++;
					if (OShip.x > OShip.nx) OShip.x--;
					
					if (OShip.y < OShip.ny) OShip.y++;
					if (OShip.y > OShip.ny) OShip.y--;		
				}
			
			//OShip.x+=Random(-1,1)	
			
		}		
		
	///////////////////////////////////////////////////////////////////////////////////////////////


	switch (gShipBattle_Data.point)
		{

			case ZOOM_POINT:
				
				//Update until enemy/player ships are in proper position, then set to target point

				//if (gShipBattle_Data.turn == PLAYER_TURN) 
				//	{				
						Ship.nx = -30 //p
						Ship.ny = -10
								
						OShip.nx = 0 //e
						OShip.ny = 0
						
						if (Ship.x == Ship.nx && Ship.y == Ship.ny && OShip.x == OShip.nx && OShip.y == OShip.ny)
							{
								gShipBattle_Data.targetx = 320/2
								gShipBattle_Data.targety = 240/2
								gShipBattle_Data.timer = 100;
								gShipBattle_Data.point = TARGET_POINT
							}
								
						if (gShipBattle_Data.move_timer <= 0)
							{						
								if (Ship.zoom > .5) Ship.zoom -= .03
								if (OShip.zoom < 1) OShip.zoom += .03
							}
				/*	}
				else
					{
						Ship.nx = 160 //e
						Ship.ny = -10
								
						OShip.nx = 0 //p
						OShip.ny = 0
								
						if (gShipBattle_Data.move_timer <= 0)
							{						
								if (Ship.zoom > .5) Ship.zoom -= .03
								if (OShip.zoom < 1) OShip.zoom += .03
							}					
					}*/

			
			break; case TARGET_POINT:
			
				if (gShipBattle_Data.targety < 0) gShipBattle_Data.targety = 0;
				if (gShipBattle_Data.targety > 220) gShipBattle_Data.targety = 220;
				if (gShipBattle_Data.targetx > 300) gShipBattle_Data.targetx = 300;
				if (gShipBattle_Data.targetx < 0) gShipBattle_Data.targetx = 0
				
				if (gShipBattle_Data.move_timer <= 0)
					{				
						gShipBattle_Data.timer--;		//Execute targeting timer
					}
							
				if (gShipBattle_Data.turn == PLAYER_TURN) //if turn is PLAYER_TURN
					{
						//Execute target position maniupulation
						
						if (Random(0,3) == 2)
							{
								gShipBattle_Data.targetx += Random(-12+gShipBattle_Data.Player_Ship.stats.accuracy,
																									 12-gShipBattle_Data.Player_Ship.stats.accuracy)
								gShipBattle_Data.targety += Random(-12+gShipBattle_Data.Player_Ship.stats.accuracy,
																									 12-gShipBattle_Data.Player_Ship.stats.accuracy)
							}
					
						//Execute evasion AI for enemy		
						
						if (OShip.dir == 0)
							{
								if (OShip.bx	< 8*gShipBattle_Data.Enemy_Ship.stats.speed) OShip.nx += 1
								if (OShip.bx	< 8*gShipBattle_Data.Enemy_Ship.stats.speed) OShip.bx += 1
							}
						else
							{
								if (OShip.bx	> -8*gShipBattle_Data.Enemy_Ship.stats.speed) OShip.nx -= 1
								if (OShip.bx	> -8*gShipBattle_Data.Enemy_Ship.stats.speed) OShip.bx -= 1
							}
							
						if (Random(0,180) == 45)
							{
								if (OShip.dir == 0)
									OShip.dir = 1;
								else { OShip.dir = 0; }
							}
					}
				
				if (gShipBattle_Data.turn == ENEMY_TURN) //if turn is ENEMY_TURN
					{
						//Execute targeting AI for enemy
						
						if (gShipBattle_Data.EnemyTarget == -1)
							{
								gShipBattle_Data.EnemyTarget = Random(0, OShip.mushrooms.length-1)
							}
							
						var tx = OShip.x+OShip.mushrooms[gShipBattle_Data.EnemyTarget].x*16
						var ty = OShip.y+OShip.mushrooms[gShipBattle_Data.EnemyTarget].y*16

						if (Random(0,3) == 2)
							{						
								gShipBattle_Data.targetx += Random(-12+gShipBattle_Data.Enemy_Ship.stats.accuracy,
																									 12-gShipBattle_Data.Enemy_Ship.stats.accuracy)
								gShipBattle_Data.targety += Random(-12+gShipBattle_Data.Enemy_Ship.stats.accuracy,
																									 12-gShipBattle_Data.Enemy_Ship.stats.accuracy)
							}
						
						if (Random(0,3) == 2)
							{
								
								if (gShipBattle_Data.targetx < tx) gShipBattle_Data.targetx+=1
								if (gShipBattle_Data.targetx > tx) gShipBattle_Data.targetx-=1
										
								if (gShipBattle_Data.targety < ty) gShipBattle_Data.targety+=1
								if (gShipBattle_Data.targety > ty) gShipBattle_Data.targety-=1	
							}
					}
				
				if (gShipBattle_Data.timer <= 0)
					{
						PlaySfx("cannon.wav")
					
						gShipBattle_Data.EnemyTarget = -1;
					
						gShipBattle_Data.projectile = new Array()
					
						gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(Ship.x,Ship.y, 
																							gShipBattle_Data.targetx-16, gShipBattle_Data.targety-16, 
																							Ship.ammo[Ship.current_shot].type, Ship.ammo[Ship.current_shot]) )
																			
						var i = gShipBattle_Data.projectile.length-1													
																							
						gShipBattle_Data.projectile[i].type = Ship.ammo[Ship.current_shot].type
																							
						gShipBattle_Data.projectile[i].image = GetImage(	GetMushroomTypePicture(Ship.ammo[Ship.current_shot].type) )
																							
						gShipBattle_Data.projectile[i].image_cache = { }																	
																							
						Ship.ammo.splice(Ship.current_shot,1)
						Ship.current_shot = Random(0, Ship.ammo.length-2)
						
						gShipBattle_Data.projectile[i].x = Ship.x+60
						gShipBattle_Data.projectile[i].y = Ship.y+60
						
						gShipBattle_Data.point = ATTACK_POINT
					}

			break; case ATTACK_POINT:
		
				var done_count = 0
		
				for (var i = 0; i < gShipBattle_Data.projectile.length; i++)
					{
		
						gShipBattle_Data.projectile[i].Execute() //Execute projectile
						
						//if projectile has reached destination, execute damage and play a brief animation
						

							
						//After displaying brief explosion animation, change turns	
						if (gShipBattle_Data.projectile[i].boom == true && gShipBattle_Data.projectile[i].point >= 50)
							{
								done_count++
							}
					}
					
				if (gShipBattle_Data.projectile.length == done_count)
					{
						for (var i = 0; i < gShipBattle_Data.projectile.length; i++)
							{										
								ShipBattle_CalculateDamage(gShipBattle_Data.projectile[i].x,
																					 gShipBattle_Data.projectile[i].y,
																					 OShip, Ship, gShipBattle_Data.projectile[i])
							}	
									
						gShipBattle_Data.point = ZOOM_POINT
								
						if (gShipBattle_Data.turn == PLAYER_TURN)
							gShipBattle_Data.turn = ENEMY_TURN
						else { gShipBattle_Data.turn = PLAYER_TURN }
					}
				
			break;
			
		}
		
	//Check player and enemy's hulls to tell if they've sustained enough damage to end the fight.
	
		var pMush = gShipBattle_Data.Player_Ship.mushrooms.length
		var pOldMush = gShipBattle_Data.Player_Ship.old_mushrooms.length
		
		var eMush = gShipBattle_Data.Enemy_Ship.mushrooms.length
		var eOldMush = gShipBattle_Data.Enemy_Ship.old_mushrooms.length		
		
		if (pMush <= pOldMush/1.5 || gShipBattle_Data.Player_Ship.mushrooms.length <= 0)
			{
				EndShipBattle()
				GameOver()					
			}
			
		if (eMush <= eOldMush/1.5 || gShipBattle_Data.Enemy_Ship.mushrooms.length <= 0)
			{
				Battle_SinkWin()
				EndShipBattle()
			}			
		
	if (gShipBattle_Data.move_timer <= 0)	gShipBattle_Data.move_timer = 2
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ShipBattle_UpdateInput()
{	
		var eMush = gShipBattle_Data.Enemy_Ship.mushrooms.length
		var eOldMush = gShipBattle_Data.Enemy_Ship.old_mushrooms.length		
			
		if (eMush <= eOldMush/1.2)
			{
				gEnemyBoardable = true
			}			
		else
			{
				gEnemyBoardable = false
			}


	//if (IsKeyPressed(KEY_A)) Abort(gShipBattle_Data.projectile.point+"-"+gShipBattle_Data.projectile.boom)
	//if (IsKeyPressed(KEY_S)) gShipBattle_Data.turn = ENEMY_TURN
	
	if (gShipBattle_Data.turn == PLAYER_TURN && gShipBattle_Data.point == TARGET_POINT)//if point is TARGET_POINT and turn is PLAYER_TURN 
		{//Respond to player input

			if ( IsKeyPressed(k_up))
				gShipBattle_Data.targety--
										
			if ( IsKeyPressed(k_down))
				gShipBattle_Data.targety++
											
			if ( IsKeyPressed(k_right))
				gShipBattle_Data.targetx++
											
			if ( IsKeyPressed(k_left))
				gShipBattle_Data.targetx--
				
			if ( IsKeyPressed(k_a) )
				gShipBattle_Data.timer = 0;
				
			if ( IsKeyPressed(k_b) && gEnemyBoardable == true)
				{
					Battle_BoardWin(gShipBattle_Data.Enemy_Ship.mushrooms)
					EndShipBattle()
				}
		
		}
		
	if (gShipBattle_Data.turn == ENEMY_TURN && gShipBattle_Data.point == TARGET_POINT) 
		{	//if point is TARGET_POINT and turn is ENEMY_TURN
		
			//Respond to player navigation input
			if ( IsKeyPressed(k_right))
				{
					if (gShipBattle_Data.Player_Ship.x < 8*gShipBattle_Data.Player_Ship.stats.speed)
						gShipBattle_Data.Player_Ship.x+=1
				}
											
			if ( IsKeyPressed(k_left))
				{			
					if (gShipBattle_Data.Player_Ship.x > -8*gShipBattle_Data.Player_Ship.stats.speed)
						gShipBattle_Data.Player_Ship.x-=1
				}
				
		}
	else
		{
			gShipBattle_Data.Player_Ship.bx = 0;
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ShipBattle_Render()
{
	//Render background

	GetImage(gShipBattle_Data.background).blit(gShipBattle_Data.bg_pos-320,0)
	GetImage(gShipBattle_Data.background).blit(gShipBattle_Data.bg_pos,0)

	//Render ships
	
	if (gShipBattle_Data.turn == PLAYER_TURN)
		{
			var Ship = gShipBattle_Data.Player_Ship
			var OShip = gShipBattle_Data.Enemy_Ship
		}
		
	if (gShipBattle_Data.turn == ENEMY_TURN)
		{
			var Ship = gShipBattle_Data.Enemy_Ship
			var OShip = gShipBattle_Data.Player_Ship
		}		
	
	Ship.blitSelf(Ship.x, Ship.y, Ship.zoom)
	
	OShip.blitSelf(OShip.x, OShip.y, OShip.zoom)

	if (gShipBattle_Data.point  != ZOOM_POINT)
		{

			if (gShipBattle_Data.turn == PLAYER_TURN)
				{
					GetImage("player_pointer.png").blit( Ship.x+60, Ship.y+110)
				}
				
			if (gShipBattle_Data.turn == ENEMY_TURN)
				{
					GetImage("player_pointer.png").blit( OShip.x+140, OShip.y+210)
				}		
				
		}
	
			
		
	if (gShipBattle_Data.point  == TARGET_POINT) //if point is TARGET_POINT
		
		GetImage("target.png").blit(gShipBattle_Data.targetx, gShipBattle_Data.targety) //Render targeting
	
	
	if (gShipBattle_Data.point  == ATTACK_POINT) //if point is ATTACK_POINT
	
		for (var i = 0; i < gShipBattle_Data.projectile.length; i++)
			{
				gShipBattle_Data.projectile[i].blitSelf() //Render projectile
			}
		//font.drawText(10,20,gShipBattle_Data.projectile.type)
	
	//Render interface
	
		//font.drawText(10,10, "PLAYER")
		//font.drawText(280,200, "ENEMY")
	
		//blit number of ammo left for player
		//blit number of ammo left for enemy
		
		font.drawText(10,10, "Ammo Left: "+gShipBattle_Data.Player_Ship.ammo.length)
		
		/*font.drawText(210,170, "Ship Statistics")
		font.drawText(230,180, "Cannon: "+gShipBattle_Data.Player_Ship.stats.cannon)
		font.drawText(230,190, "Hull: "+gShipBattle_Data.Player_Ship.stats.hp)
		font.drawText(230,200, "Speed: "+gShipBattle_Data.Player_Ship.stats.speed)
		font.drawText(230,210, "Accuracy: "+gShipBattle_Data.Player_Ship.stats.accuracy)
		font.drawText(230,220, "Value: "+gShipBattle_Data.Player_Ship.stats.value)*/
		
		
		
		//font.drawText(10,40, gShipBattle_Data.Enemy_Ship.ammo.length+"-"+gShipBattle_Data.Enemy_Ship.mushrooms.length)
		
		//blit player stats
		//blit enemy stats
		
		//blit targeting timer if targeting
				
		var pMush = gShipBattle_Data.Player_Ship.mushrooms.length
		var pOldMush = gShipBattle_Data.Player_Ship.old_mushrooms.length
		
		var eMush = gShipBattle_Data.Enemy_Ship.mushrooms.length
		var eOldMush = gShipBattle_Data.Enemy_Ship.old_mushrooms.length		
		
		if (pMush <= pOldMush/1.2)
			{
				font.drawText(120,230,"PLAYER BOARDABLE")
				//gPlayerBoardable = true
			}
		else
			{
				//gPlayerBoardable = false
			}
			
		if (eMush <= eOldMush/1.2)
			{
				font.drawText(120,220,"ENEMY BOARDABLE")
				//gEnemyBoardable = true
			}			
		else
			{
				//gEnemyBoardabe = false
			}
		
		if (gShipBattle_Data.point  == TARGET_POINT)
			{
				font.drawText(150,10, "TIMER")
				font.drawText(160,20, gShipBattle_Data.timer)
				
				font.drawText(260,10, "Firing: ")
				GetImage(GetMushroomTypePicture(Ship.ammo[Ship.current_shot].type)).blit(270,25)
				font.drawText(255,40, "Opposite: ")
				GetImage(GetMushroomTypePicture(GetMushroomStats(Ship.ammo[Ship.current_shot]).opposite)).blit(270,55)
			}
	
}

var gEnemyBoardable = false
//var gPlayerBoardable = false

///////////////////////////////////////////////////////////////////////////////////////////////

function ShipBattle_oData(Player_Ship, Enemy_Ship, bg, fg)
{
	this.Player_Ship = Clone(Player_Ship)
	this.Enemy_Ship = Clone(Enemy_Ship)
	this.projectile  = new Array()
	
	this.turn = PLAYER_TURN
	this.point = ZOOM_POINT //Part of the turn currently executing
	
	this.timer = 0 //Targeting timer
	this.targetx = 0
	this.targety = 0
	this.EnemyTarget = -1; //Enemy's Target
	
	this.move_timer = 0 //Moving timer
	this.background = bg
	this.foreground = fg
	this.bg_pos = 0
	this.fg_pos = 0
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ShipBattle_oProjectile(x,y,dx,dy, type, mush)
{
	this.x = x
	this.y = y
	this.dx = dx
	this.dy = dy
	this.xv = 0
	this.yv = 0
	this.zoom = .5
	this.point = 0
	this.spawn = false

	this.type = type
	this.mush = mush

	this.image = GetImage( GetMushroomTypePicture(type) )
	
	this.image_cache = { }
	
	this.boom = false
	
	this.blitSelf = function blitSelf()
		{
			this.GetImageCache(this.zoom).blit(this.x, this.y);
		}
		
	this.GetImageCache = function GetImageCache(zoom)
		{
			if (!(zoom in this.image_cache)) 
			{
				
				var surf = this.image.createSurface()

				surf.rescale(this.image.width * zoom, this.image.height * zoom)
					
				surf = surf.createImage()	
				
				this.image_cache[zoom] = surf;  
			}
			return this.image_cache[zoom];		
		}	
		
	this.Execute = function Execute()
		{
			this.point++
		
			if (this.dx > this.x && this.xv < 8) this.xv += .02
			if (this.dx < this.x && this.xv > -6) this.xv = 0
		
			if (this.dx-100 > this.x) this.xv += .05
			if (this.dx-200 > this.x) this.xv += .2
		
			if (this.point < 50) this.yv = -1
			
			else
				{
					if (this.dy > this.y && this.yv < 4) this.yv += .1
					if (this.dy < this.y && this.yv > -4) this.yv += -.1
					if (this.dx < this.x && this.xv > -6) this.x--
				}
				
			if (this.boom) { this.xv = 0; this.yv = 0; }
				
			///////////////////////////////////////////////////////////////////////////////////	
			
			if (this.type == 1 && this.boom && this.point == 5 && this.spawn == false)
				{
					for (var i = 0; i < Random(1,5); i++)
						{
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x+Random(-50,50), this.y+Random(-50,50), 
								this.type, this.mush) )			
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;					
						}

				}
				
			///////////////////////////////////////////////////////////////////////////////////	
				
			if (this.type == 2 && this.boom && this.point == 5 && this.spawn == false)
				{
					var length = Random(30,70)
					var angle = 0
					var x = 0
					var y = 0
					
					while (angle < 2 * Math.PI)
						{
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x + ( length * cos(angle) ) + Random(-25,25), this.y + ( length * sin(angle) ) + Random(-25,25), 
								this.type, this.mush) )			
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;		
							
							angle+=.8
						}

				}				
				
			///////////////////////////////////////////////////////////////////////////////////	
			
			if (this.type == 3 && !this.boom && this.spawn == false && Random(0,15) == 5) 
				{
					gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
						this.x+Random(-10,10), this.y+Random(-10,80), 
						this.type, this.mush) )			
					gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;				
				}
				
			///////////////////////////////////////////////////////////////////////////////////		
			
			if (this.type == 5 && this.boom && this.spawn == false) 
				{
					this.zoom += .05
					if (this.point == 1) 
						{
							this.image_cache = { }
							this.image = GetImage( GetMushroomTypePicture(this.type) )
						}
					if (Random(0,2) == 1 && this.point < 50)
						{
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x+Random(-50,50), this.y+Random(-50,50), 
								this.type, this.mush) )			
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;			
						}	
					if (this.point > 50)
						{
							this.image_cache = { }
							this.image = GetImage( "boom.png" )
						}
				}
				
			///////////////////////////////////////////////////////////////////////////////////	
			
			if (this.type == 4 && this.boom && this.point == 5 && this.spawn == false) 
				{
					for (var i = 0; i < Random(5,10); i++)
						{
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x+(i*10), this.y+(i*10), 
								this.type, this.mush) )			
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;					
						}
				}
				
			///////////////////////////////////////////////////////////////////////////////////									

			if (this.type == 9 && this.boom && this.point == 2 && this.spawn == false) 
				{
					for (var i = 0; i < Random(3,7); i++)
						{
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x+Random(-16,16), this.y+Random(-16,16), 
								this.type, this.mush) )			
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;				
						}
				}
				
			///////////////////////////////////////////////////////////////////////////////////
			
			if (this.type == 7 && this.boom && this.point == 1 && this.spawn == false) 
				{
					for (var i = 0; i < 3; i++)
						{
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x+(i*20), this.y, 
								this.type, this.mush) )		
								
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;		
								
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x-(i*20), this.y, 
								this.type, this.mush) )		
								
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;		
								
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x, this.y+(i*20), 
								this.type, this.mush) )		
								
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;		
								
							gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
								this.x, this.y-(i*20), 
								this.type, this.mush) )					
																														
							gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;					
						}
				}
				
			///////////////////////////////////////////////////////////////////////////////////							

			if (this.type == 8 && !this.boom && this.spawn == false && Random(0,10) == 4 && this.point < 200 && this.point > 50) 
				{
					this.zoom += .2
				
					gShipBattle_Data.projectile.push( new ShipBattle_oProjectile(this.x,this.y, 
						Random(0,320), Random(0,240), 
						this.type, this.mush) )			
						
					gShipBattle_Data.projectile[gShipBattle_Data.projectile.length-1].spawn = true;				
				}
				
			///////////////////////////////////////////////////////////////////////////////////	
			
			this.x += this.xv
			this.y += this.yv
			
			if (this.x+2 > this.dx &&
					this.x-2 < this.dx &&
					this.y+2 > this.dy &&
					this.y-2 < this.dy &&
					this.boom == false)
				{
					switch (Random(0,2))
						{
							case 0:
								PlaySfx("explode.wav")
							break; case 1:
								PlaySfx("explosion.wav")
							break; case 2:
								PlaySfx("explosion2.wav")
							break;	
						}
				
					this.image_cache = { }
					this.image = GetImage("boom.png")
					this.boom = true
					this.point = 0
				}			
			
			if (this.zoom < 2) this.zoom += .01
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ShipBattle_CalculateDamage(x, y, Ship, EnemyShip, projectile)
{
	//var tx = Math.floor((x - Ship.x + (GetImage("target.png").width/2) ) / 16)
	//var ty = Math.floor((y - Ship.y + (GetImage("target.png").height/2) ) / 16)
	
	var tx = PixelToTile(x - Ship.x + (GetImage("target.png").width/2),y - Ship.y)[0]
	var ty = PixelToTile(x - Ship.x,y - Ship.y + (GetImage("target.png").height/2))[1]
	
	//Abort(tx+"-"+ty)
	/*scrn = GrabImage(0,0,320,240)
	while(!IsKeyPressed(KEY_ENTER))
		{
			
			scrn.blit(0,0)
			
			GetImage("target.png").blit(x,y)
			GetImage("obs.png").blit( (tx*16) + Ship.x, (ty*16) + Ship.y)
			Point(x, y, CreateColor(255,255,0))
			FlipScreen()
			
		}		*/
	
	var m = ShipBattle_FindMushroomXY(tx, ty, Ship.mushrooms)
	
	if (m != -1)
		{
			var dmg = GetMushroomStats(projectile.mush).cannon
			if (GetMushroomStats(projectile.mush).opposite == Ship.mushrooms[m].type) dmg = dmg+2
			Ship.mushrooms[m].hp -= dmg
			
			if (Ship.mushrooms[m].hp <= 0) Ship.mushrooms.splice(m,1)
			
			Ship.RegenerateShipData()
			//EnemyShip.RegenerateShipData()	
		}
	//Ship.RegenerateShipData()
	//EnemyShip.RegenerateShipData()	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ShipBattle_FindMushroomXY(x, y, mush)
{
	for (var i = 0; i < mush.length; i++)
		{
			if (mush[i].x == x && mush[i].y == y)
				return i
		}
	return -1
}

///////////////////////////////////////////////////////////////////////////////////////////////

function StartShipBattle(Player_Ship, Enemy_Ship, bg, fg)
{
	
	gEnemyBoardable = false

	gSuspendMovement = true

	if (gFlags[11] == false)
		{
			txt_BattleTut()
			
			gFlags[11] = true
		}

	PlaySound("pibattle.it")

	Player_Ship.RegenerateShipData()
	Enemy_Ship.RegenerateShipData()

	gShipBattle_Data = new ShipBattle_oData(Player_Ship, Enemy_Ship, bg, fg)
	
	UProcList.push(ShipBattle_Update)
	UProcList.push(ShipBattle_UpdateInput)
	
	RProcList.push(ShipBattle_Render)
	
	//Abort(UProcList)
}

///////////////////////////////////////////////////////////////////////////////////////////////

function EndShipBattle()
{

	RemItem(UProcList, ShipBattle_Update)
	RemItem(UProcList, ShipBattle_UpdateInput)
	
	RemItem(RProcList, ShipBattle_Render)
	
	//Execute after-battle code here

}

///////////////////////////////////////////////////////////////////////////////////////////////

function GenerateShipBattle(enemy_mush_types, enemy_ship_type, enemy_mush_amount)
{
	//LeaveShop()
	
	var enemy_mush = new Array()

	switch (enemy_ship_type)
		{
			case 0:
				var enemy_img = "ship0.png"
				var enemy_img2 = "ship0-2.png"
			break; case 1:
				var enemy_img = "ship1.png"
				var enemy_img2 = "ship1-2.png"
			break; case 2:
				var enemy_img = "ship2.png"
				var enemy_img2 = "ship2-2.png"
			break;	
		}

	var obs = ItemBuild_ConvertImageToObstacle(enemy_img)

	var x,y

	for (var i = 0; i < enemy_mush_amount; i++)
		{
			x = Random(0,19)
			y = Random(0,14)
			
			while (IsObstructedShp(x, y, obs, enemy_mush)) { x = Random(0,19); y = Random(0,14); }
			
			enemy_mush.push ( new ItemBuild_oBlock(x, y, enemy_mush_types[Random(0,enemy_mush_types.length-1)] ) )
		
		
		}

	var mush = gPlayer_Ship.mushrooms

	var mush1 = new Array()
	var mush2 = new Array()
	
	for (var i = 0; i < mush.length; i++)
		{
			mush1[i] = Clone(mush[i])
			mush1[i].hp = GetMushroomStats(mush[i]).hp
					
		}
	
	//Abort(enemy_mush[0].type)	
		
	for (var i = 0; i < enemy_mush.length; i++)
		{	
			mush2[i] = Clone(enemy_mush[i])
			mush2[i].hp = GetMushroomStats(enemy_mush[i]).hp	
			enemy_mush[i].hp = GetMushroomStats(enemy_mush[i]).hp			
		}		

	//var s = new oShip("ship0-2.png", mush1, mush2, 5,5,5,415,5,10)
	var s2 = new oShip(enemy_img2, enemy_mush, mush2)
	var s = gPlayer_Ship
	
	s.ammo = mush1
	
	s.RegenerateShipData()
	s2.RegenerateShipData()
	
	StartShipBattle(s,s2, "bg2.png", "fg.png")
}

function IsObstructedShp(x, y, obs, mush)
{
	for (var i = 0; i < obs.length; i++) 
		{ //Check default obstructions to see if the X Y would have a collision with them.
				
			if (obs[i].x == x && 
					obs[i].y == y)		
				return true		
		}
		
	for (var i = 0; i < mush.length; i++) 
		{ //Check Placed Blocks to see if the X Y would have a collision with any of them.
			if (mush[i].x == x &&
					mush[i].y == y)
				return true					
		}				
}